/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.RegOptimizer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RegSMO
extends RegOptimizer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -7504070793279598638L;
    protected double m_eps = 1.0E-12;
    protected static final double m_Del = 1.0E-10;
    double[] m_error;
    protected double m_alpha1;
    protected double m_alpha1Star;
    protected double m_alpha2;
    protected double m_alpha2Star;

    public String globalInfo() {
        return "Implementation of SMO for support vector regression as described in :\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A.J. Smola and B. Schoelkopf");
        result.setValue(TechnicalInformation.Field.TITLE, "A tutorial on support vector regression");
        result.setValue(TechnicalInformation.Field.NOTE, "NeuroCOLT2 Technical Report NC2-TR-1998-030");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe epsilon for round-off error.\n\t(default 1.0e-12)", "P", 1, "-P <double>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setEpsilon(Double.parseDouble(tmpStr));
        } else {
            this.setEpsilon(1.0E-12);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-P");
        result.add("" + this.getEpsilon());
        return result.toArray(new String[result.size()]);
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double v) {
        this.m_eps = v;
    }

    @Override
    protected void init(Instances data) throws Exception {
        super.init(data);
        this.m_error = new double[this.m_nInstances];
        int i = 0;
        while (i < this.m_nInstances) {
            this.m_error[i] = -this.m_target[i];
            ++i;
        }
    }

    @Override
    protected void wrapUp() throws Exception {
        this.m_error = null;
        super.wrapUp();
    }

    protected boolean findOptimalPointOnLine(int i1, double alpha1, double alpha1Star, double C1, int i2, double alpha2, double alpha2Star, double C2, double gamma, double eta, double deltaPhi) {
        if (eta <= 0.0) {
            return false;
        }
        boolean case1 = false;
        boolean case2 = false;
        boolean case3 = false;
        boolean case4 = false;
        boolean finished = false;
        while (!finished) {
            double a1;
            double a2;
            double H;
            double L;
            if (!case1 && (alpha1 > 0.0 || alpha1Star == 0.0 && deltaPhi > 0.0) && (alpha2 > 0.0 || alpha2Star == 0.0 && deltaPhi < 0.0)) {
                L = Math.max(0.0, gamma - C1);
                if (L < (H = Math.min(C2, gamma))) {
                    a2 = alpha2 - deltaPhi / eta;
                    a2 = Math.min(a2, H);
                    if ((a2 = Math.max(L, a2)) > C2 - 1.0E-10 * C2) {
                        a2 = C2;
                    } else if (a2 <= 1.0E-10 * C2) {
                        a2 = 0.0;
                    }
                    a1 = alpha1 - (a2 - alpha2);
                    if (a1 > C1 - 1.0E-10 * C1) {
                        a1 = C1;
                    } else if (a1 <= 1.0E-10 * C1) {
                        a1 = 0.0;
                    }
                    if (Math.abs(alpha1 - a1) > this.m_eps) {
                        deltaPhi += eta * (a2 - alpha2);
                        alpha1 = a1;
                        alpha2 = a2;
                    }
                } else {
                    finished = true;
                }
                case1 = true;
                continue;
            }
            if (!case2 && (alpha1 > 0.0 || alpha1Star == 0.0 && deltaPhi > 2.0 * this.m_epsilon) && (alpha2Star > 0.0 || alpha2 == 0.0 && deltaPhi > 2.0 * this.m_epsilon)) {
                L = Math.max(0.0, -gamma);
                if (L < (H = Math.min(C2, -gamma + C1))) {
                    a2 = alpha2Star + (deltaPhi - 2.0 * this.m_epsilon) / eta;
                    a2 = Math.min(a2, H);
                    if ((a2 = Math.max(L, a2)) > C2 - 1.0E-10 * C2) {
                        a2 = C2;
                    } else if (a2 <= 1.0E-10 * C2) {
                        a2 = 0.0;
                    }
                    a1 = alpha1 + (a2 - alpha2Star);
                    if (a1 > C1 - 1.0E-10 * C1) {
                        a1 = C1;
                    } else if (a1 <= 1.0E-10 * C1) {
                        a1 = 0.0;
                    }
                    if (Math.abs(alpha1 - a1) > this.m_eps) {
                        deltaPhi += eta * (-a2 + alpha2Star);
                        alpha1 = a1;
                        alpha2Star = a2;
                    }
                } else {
                    finished = true;
                }
                case2 = true;
                continue;
            }
            if (!case3 && (alpha1Star > 0.0 || alpha1 == 0.0 && deltaPhi < -2.0 * this.m_epsilon) && (alpha2 > 0.0 || alpha2Star == 0.0 && deltaPhi < -2.0 * this.m_epsilon)) {
                L = Math.max(0.0, gamma);
                if (L < (H = Math.min(C2, C1 + gamma))) {
                    a2 = alpha2 - (deltaPhi + 2.0 * this.m_epsilon) / eta;
                    a2 = Math.min(a2, H);
                    if ((a2 = Math.max(L, a2)) > C2 - 1.0E-10 * C2) {
                        a2 = C2;
                    } else if (a2 <= 1.0E-10 * C2) {
                        a2 = 0.0;
                    }
                    a1 = alpha1Star + (a2 - alpha2);
                    if (a1 > C1 - 1.0E-10 * C1) {
                        a1 = C1;
                    } else if (a1 <= 1.0E-10 * C1) {
                        a1 = 0.0;
                    }
                    if (Math.abs(alpha1Star - a1) > this.m_eps) {
                        deltaPhi += eta * (a2 - alpha2);
                        alpha1Star = a1;
                        alpha2 = a2;
                    }
                } else {
                    finished = true;
                }
                case3 = true;
                continue;
            }
            if (!case4 && (alpha1Star > 0.0 || alpha1 == 0.0 && deltaPhi < 0.0) && (alpha2Star > 0.0 || alpha2 == 0.0 && deltaPhi > 0.0)) {
                L = Math.max(0.0, -gamma - C1);
                if (L < (H = Math.min(C2, -gamma))) {
                    a2 = alpha2Star + deltaPhi / eta;
                    a2 = Math.min(a2, H);
                    if ((a2 = Math.max(L, a2)) > C2 - 1.0E-10 * C2) {
                        a2 = C2;
                    } else if (a2 <= 1.0E-10 * C2) {
                        a2 = 0.0;
                    }
                    a1 = alpha1Star - (a2 - alpha2Star);
                    if (a1 > C1 - 1.0E-10 * C1) {
                        a1 = C1;
                    } else if (a1 <= 1.0E-10 * C1) {
                        a1 = 0.0;
                    }
                    if (Math.abs(alpha1Star - a1) > this.m_eps) {
                        deltaPhi += eta * (-a2 + alpha2Star);
                        alpha1Star = a1;
                        alpha2Star = a2;
                    }
                } else {
                    finished = true;
                }
                case4 = true;
                continue;
            }
            finished = true;
        }
        if (Math.abs(alpha1 - this.m_alpha[i1]) > this.m_eps || Math.abs(alpha1Star - this.m_alphaStar[i1]) > this.m_eps || Math.abs(alpha2 - this.m_alpha[i2]) > this.m_eps || Math.abs(alpha2Star - this.m_alphaStar[i2]) > this.m_eps) {
            if (alpha1 > C1 - 1.0E-10 * C1) {
                alpha1 = C1;
            } else if (alpha1 <= 1.0E-10 * C1) {
                alpha1 = 0.0;
            }
            if (alpha1Star > C1 - 1.0E-10 * C1) {
                alpha1Star = C1;
            } else if (alpha1Star <= 1.0E-10 * C1) {
                alpha1Star = 0.0;
            }
            if (alpha2 > C2 - 1.0E-10 * C2) {
                alpha2 = C2;
            } else if (alpha2 <= 1.0E-10 * C2) {
                alpha2 = 0.0;
            }
            if (alpha2Star > C2 - 1.0E-10 * C2) {
                alpha2Star = C2;
            } else if (alpha2Star <= 1.0E-10 * C2) {
                alpha2Star = 0.0;
            }
            this.m_alpha[i1] = alpha1;
            this.m_alphaStar[i1] = alpha1Star;
            this.m_alpha[i2] = alpha2;
            this.m_alphaStar[i2] = alpha2Star;
            if (alpha1 != 0.0 || alpha1Star != 0.0) {
                if (!this.m_supportVectors.contains(i1)) {
                    this.m_supportVectors.insert(i1);
                }
            } else {
                this.m_supportVectors.delete(i1);
            }
            if (alpha2 != 0.0 || alpha2Star != 0.0) {
                if (!this.m_supportVectors.contains(i2)) {
                    this.m_supportVectors.insert(i2);
                }
            } else {
                this.m_supportVectors.delete(i2);
            }
            return true;
        }
        return false;
    }

    protected int takeStep(int i1, int i2, double alpha2, double alpha2Star, double phi2) throws Exception {
        double k22;
        if (i1 == i2) {
            return 0;
        }
        double C1 = this.m_C * this.m_data.instance(i1).weight();
        double C2 = this.m_C * this.m_data.instance(i2).weight();
        double alpha1 = this.m_alpha[i1];
        double alpha1Star = this.m_alphaStar[i1];
        double y1 = this.m_target[i1];
        double phi1 = this.m_error[i1];
        double k11 = this.m_kernel.eval(i1, i1, this.m_data.instance(i1));
        double k12 = this.m_kernel.eval(i1, i2, this.m_data.instance(i1));
        double eta = -2.0 * k12 + k11 + (k22 = this.m_kernel.eval(i2, i2, this.m_data.instance(i2)));
        if (eta < 0.0) {
            return 0;
        }
        double gamma = alpha1 - alpha1Star + alpha2 - alpha2Star;
        double alpha1old = alpha1;
        double alpha1Starold = alpha1Star;
        double alpha2old = alpha2;
        double alpha2Starold = alpha2Star;
        double deltaPhi = phi2 - phi1;
        if (this.findOptimalPointOnLine(i1, alpha1, alpha1Star, C1, i2, alpha2, alpha2Star, C2, gamma, eta, deltaPhi)) {
            alpha1 = this.m_alpha[i1];
            alpha1Star = this.m_alphaStar[i1];
            alpha2 = this.m_alpha[i2];
            alpha2Star = this.m_alphaStar[i2];
            double dAlpha1 = alpha1 - alpha1old - (alpha1Star - alpha1Starold);
            double dAlpha2 = alpha2 - alpha2old - (alpha2Star - alpha2Starold);
            int j = 0;
            while (j < this.m_nInstances) {
                if (j != i1 && j != i2) {
                    int n = j;
                    this.m_error[n] = this.m_error[n] + (dAlpha1 * this.m_kernel.eval(i1, j, this.m_data.instance(i1)) + dAlpha2 * this.m_kernel.eval(i2, j, this.m_data.instance(i2)));
                }
                ++j;
            }
            int n = i1;
            this.m_error[n] = this.m_error[n] + (dAlpha1 * k11 + dAlpha2 * k12);
            int n2 = i2;
            this.m_error[n2] = this.m_error[n2] + (dAlpha1 * k12 + dAlpha2 * k22);
            double b1 = Double.MAX_VALUE;
            double b2 = Double.MAX_VALUE;
            if (0.0 < alpha1 && alpha1 < C1 || 0.0 < alpha1Star && alpha1Star < C1 || 0.0 < alpha2 && alpha2 < C2 || 0.0 < alpha2Star && alpha2Star < C2) {
                if (0.0 < alpha1 && alpha1 < C1) {
                    b1 = this.m_error[i1] - this.m_epsilon;
                } else if (0.0 < alpha1Star && alpha1Star < C1) {
                    b1 = this.m_error[i1] + this.m_epsilon;
                }
                if (0.0 < alpha2 && alpha2 < C2) {
                    b2 = this.m_error[i2] - this.m_epsilon;
                } else if (0.0 < alpha2Star && alpha2Star < C2) {
                    b2 = this.m_error[i2] + this.m_epsilon;
                }
                if (b1 < Double.MAX_VALUE) {
                    this.m_b = b1;
                    if (b2 < Double.MAX_VALUE) {
                        this.m_b = (b1 + b2) / 2.0;
                    }
                } else if (b2 < Double.MAX_VALUE) {
                    this.m_b = b2;
                }
            } else if (this.m_b == 0.0) {
                this.m_b = (this.m_error[i1] + this.m_error[i2]) / 2.0;
            }
            return 1;
        }
        return 0;
    }

    protected int examineExample(int i2) throws Exception {
        double y2 = this.m_target[i2];
        double alpha2 = this.m_alpha[i2];
        double alpha2Star = this.m_alphaStar[i2];
        double C2 = this.m_C;
        double C2Star = this.m_C;
        double phi2 = this.m_error[i2];
        double phi2b = phi2 - this.m_b;
        if (phi2b > this.m_epsilon && alpha2Star < C2Star || phi2b < this.m_epsilon && alpha2Star > 0.0 || -phi2b > this.m_epsilon && alpha2 < C2 || -phi2b > this.m_epsilon && alpha2 > 0.0) {
            int i1 = this.secondChoiceHeuristic(i2);
            if (i1 >= 0 && this.takeStep(i1, i2, alpha2, alpha2Star, phi2) > 0) {
                return 1;
            }
            i1 = 0;
            while (i1 < this.m_target.length) {
                if ((this.m_alpha[i1] > 0.0 && this.m_alpha[i1] < this.m_C || this.m_alphaStar[i1] > 0.0 && this.m_alphaStar[i1] < this.m_C) && this.takeStep(i1, i2, alpha2, alpha2Star, phi2) > 0) {
                    return 1;
                }
                ++i1;
            }
            i1 = 0;
            while (i1 < this.m_target.length) {
                if (this.takeStep(i1, i2, alpha2, alpha2Star, phi2) > 0) {
                    return 1;
                }
                ++i1;
            }
        }
        return 0;
    }

    protected int secondChoiceHeuristic(int i2) {
        int i = 0;
        while (i < 59) {
            int i1 = this.m_random.nextInt(this.m_nInstances);
            if (i1 != i2 && this.m_alpha[i1] > 0.0 && this.m_alpha[i1] < this.m_C || this.m_alphaStar[i1] > 0.0 && this.m_alphaStar[i1] < this.m_C) {
                return i1;
            }
            ++i;
        }
        return -1;
    }

    public void optimize() throws Exception {
        int numChanged = 0;
        int examineAll = 1;
        int sigFig = -100;
        int loopCounter = 0;
        while ((numChanged > 0 || examineAll > 0) | sigFig < 3) {
            int i;
            ++loopCounter;
            numChanged = 0;
            int numSamples = 0;
            if (examineAll > 0) {
                i = 0;
                while (i < this.m_nInstances) {
                    numChanged += this.examineExample(i);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.m_target.length) {
                    if (this.m_alpha[i] > 0.0 && this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight() || this.m_alphaStar[i] > 0.0 && this.m_alphaStar[i] < this.m_C * this.m_data.instance(i).weight()) {
                        ++numSamples;
                        numChanged += this.examineExample(i);
                    }
                    ++i;
                }
            }
            int minimumNumChanged = 1;
            if (loopCounter % 2 == 0) {
                minimumNumChanged = (int)Math.max(1.0, 0.1 * (double)numSamples);
            }
            if (examineAll == 1) {
                examineAll = 0;
            } else if (numChanged < minimumNumChanged) {
                examineAll = 1;
            }
            if (loopCounter == 2500) break;
        }
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.init(instances);
        this.optimize();
        this.wrapUp();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

